'use strict';

angular.module('genisis').service('system', ['ENV',
  function (ENV) {
    // Array of elevated Users
    var _elevatedUsers = ENV.elevatedAccesses;

    this.elevatedUsers = function () {
      return _elevatedUsers;
    };

    this.isAWSTestEnv = function () {
      return this.localDevelopment() ||
        this.AWSDevRelease() ||
        this.AWSDevSustainment() ||
        this.AWSTestRelease() ||
        this.AWSTestSustainment();
    };

    this.localDevelopment = function () {
      return ENV.name === 'localDevelopment';
    };

    this.AWSDevRelease = function () {
      return ENV.name === 'AWSDevRelease';
    };

    this.AWSDevSustainment = function () {
      return ENV.name === 'AWSDevSustainment';
    };

    this.AWSTestRelease = function () {
      return ENV.name === 'AWSTestRelease';
    };

    this.AWSTestSustainment = function () {
      return ENV.name === 'AWSTestSustainment';
    };

    this.vaDevelopment = function () {
      return ENV.name === 'vaDevelopment';
    };

    this.production = function () {
      return ENV.name === 'production';
    };
  }
]);